#include <stdio.h>
#include "coco.h"

#define COCO_GRAN_START_SECTOR(gno)	((gno%COCO_GRANS_PER_TRACK)*COCO_SECTORS_PER_GRAN)
#define COCO_GRAN_TRACK(gno)		(gno/COCO_GRANS_PER_TRACK+(((gno/COCO_GRANS_PER_TRACK)>=COCO_DIR_TRACK)?1:0))


/*
 * Get a complete gran into the buffer.  Buffer must be big enough!
 */

int
coco_getgran(struct cocofs *cocofs, int granno, char buffer[])
{
    int sect, track, counter;

    /* Translate gran number into logical track/sector address */

    sect = COCO_GRAN_START_SECTOR(granno);
    track = COCO_GRAN_TRACK(granno);

    /* read the gran */
    for (counter = 0; counter < COCO_SECTORS_PER_GRAN; counter++, sect++) {
	if (!coco_getpsect(cocofs, track, sect, buffer+(COCO_SECTOR_SIZE*counter))) {
	    return(FALSE);
	}
    }

    return (TRUE);
}

/*
 * Save a gran out to the floppy.
 */

int
coco_putgran(struct cocofs *cocofs, int granno, char buffer[], int sectors)
{

    int sect, track, counter;

    /* Translate gran number into logical track/sector address */

    sect = COCO_GRAN_START_SECTOR(granno);
    track = COCO_GRAN_TRACK(granno);

    /* write the gran */
    /* note that the "sectors" are the number of sectors to write in the gran	*/

    for (counter = 0; sectors-- && counter < COCO_SECTORS_PER_GRAN; counter++, sect++) {
	if (!coco_putpsect(cocofs, track, sect,buffer+(COCO_SECTOR_SIZE*counter))) {
	    return(FALSE);
	}
    }
    return (TRUE);
}
